#!/bin/sh

MASTER_PAGE_NEW_ESXI_SAVE_RESULT_OK=0
MASTER_PAGE_NEW_ESXI_SAVE_RESULT_ERROR=1
MASTER_PAGE_NEW_ESXI_SAVE_RESULT_CODE=${MASTER_PAGE_NEW_ESXI_SAVE_RESULT_ERROR}

MASTER_PAGE_NEW_ESXI_SAVE_RESULT_ROLLING=0
MASTER_PAGE_NEW_ESXI_SAVE_RESULT_MSG=""

master_page_new_esxi_save()
{
	debug_print "${0}" "${LINENO}" 'in function "master_page_new_esxi_save"'
	
    local add_ret;
    add_ret=`php $CONS_BACKEND add_new_cluster "${new_esxi_name}" "${new_esxi_host_ip}" "${new_esxi_username}" "${new_esxi_password}" "${new_esxi_ms_real_image_path}" "${new_esxi_sc_real_image_path}"`    
    if [ "${?}" -ne 0 ]; then
        warning "${MASTER_PAGE_NEW_ESXI_SAVE_INTERNAL_ERROR}" "${add_ret}"
		MASTER_PAGE_NEW_ESXI_SAVE_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SAVE_RESULT_OK
		MASTER_PAGE_NEW_ESXI_SAVE_RESULT_ROLLING=-1
        return 1
    fi
	
	#defined in master_page_add_esxi()
	new_esxi_sc_id=`echo "${add_ret}" | awk '{print $1}'`
	sh notify_configuration_change.sh
	
	MASTER_PAGE_NEW_ESXI_SAVE_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SAVE_RESULT_OK
	MASTER_PAGE_NEW_ESXI_SAVE_RESULT_ROLLING=1
	
	return 0
}